//command.c for RTOS_Serial Project
//This code is free to use
//This software is distributed on an "as is" basis, no warranty is expressed or implied. 
//Copyright Rob Silbert Limited, LLC
//This code was developed with help from Anupama Shankar Kurpad.
//A real software developer that helped me to simplify the code
//using standard C libraries.  Thank You Anu.

//http://mysite.verizon.net/vze124b2u/
//Written by Rob Silbert
//rsilbert@yahoo.com
//mobile: 

/*
	This file is part of pqrst commander.

    pqrst commander is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    pqrst commander is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with pqrst commander.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <msp430x14x.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
//#include <in430.h>
#include "commander.h"
#include "salvo.h"

//OS tasks - 3 Maximum tasks using Salvo Lite
//--------------------------------
//void GetSerialPortData(void)
//void SerialPortCommandInterpreter(void)
//void SerialPortCommandHandler(void)

/*****************************************************
*                                                    *
*			CommandPrintStartupMessage     	 	 	 *
*                                                    *
******************************************************/	
void CommandPrintStartupMessage(void)
{
	UARTPrint("\n");
	UARTPrint("                   ##        ## \n");
	UARTPrint("                  ####        ##	\n");
	UARTPrint("                  ####         ## \n");
	UARTPrint("                   ##           ## \n");
	UARTPrint("                                 ## \n");
	UARTPrint("                                  ##	\n");
	UARTPrint("                                   ## \n");
	UARTPrint("                                  ## \n");
	UARTPrint("                                 ## \n");
	UARTPrint("                   ##           ## \n");
	UARTPrint("                  ####         ## \n");
	UARTPrint("                  ####        ## \n");
	UARTPrint("                   ##        ## \n");
	UARTPrint("\n");
	UARTPrint("\n");
	UARTPrint("Welcome to pqrst commander lite for MSP430F149. v1.0\n");
	UARTPrint("Using TI MSP430, Pumpkin Salvo Lite, and Quadravox Archelon Tools.\n");
	UARTPrint("Written by Rob Silbert, RSL, LLC. and Anupama Kurpad\n");
	UARTPrint("rsilbert@yahoo.com\n");
	UARTPrint("www.verizon.net/vze124b2u\n");
	while((IFG1 & UTXIFG0) == 0);
	WriteUARTData(0x07);
}
	
/*****************************************************
*                                                    *
*				CommandLoginHandler        	 	 	 *
*                                                    *
******************************************************/	

unsigned char CommandLoginHandler(void)
{
extern unsigned char login,receive_buffer[32],password_entry,permission;	
static unsigned char i=0,username[16],password[16];
static unsigned char username1[16],password1[16],username2[16],password2[16];
static const unsigned char root[]="root",password_root[]="password";

	login = FALSE;
	UARTPrint("login: ");
	while(!CommandCheckForReturnKey());
	strcpy(username,receive_buffer);
	
	UARTPrint("password: ");
	password_entry = TRUE;
	while(!CommandCheckForReturnKey());
	strcpy(password,receive_buffer);
	//Check for canned login
	if(FlashRead((unsigned char *)USERNAME_START_ADDR) == 0xFF && FlashRead((unsigned char *)USERNAME2_START_ADDR) == 0xFF)
		if(!(strcmp(username,root)) && !(strcmp(password,password_root)))
		{
			login = TRUE; 
			permission = TRUE;
		}
	if(!login)
	{
		//retreive user1 username and password
		for(i=0;i<16;i++)
		{
			username1[i] = FlashRead((unsigned char *)(USERNAME_START_ADDR + i));
			password1[i] = FlashRead((unsigned char *)(PASSWORD_START_ADDR + i));
		}
		if(!(strcmp(username,username1)) && !(strcmp(password,password1)))
		{
			login = TRUE; 
			permission = TRUE;
		}
		//If username is "encrypted" decrypt it here
		if(!login)
		{
			for(i=0;i<16;i++)
			{
				username2[i] = FlashRead((unsigned char *)(USERNAME2_START_ADDR + i));
				password2[i] = FlashRead((unsigned char *)(PASSWORD2_START_ADDR + i));
			}
			if(!(strcmp(username,username2)) && !(strcmp(password,password2)))
			{
				login = TRUE; 
				permission = FALSE;
			}
		}
	}
	password_entry = FALSE;
	return login;
}	

/*****************************************************
*                                                    *
*				CommandPrintSerialPrompt           	 *
*                                                    *
******************************************************/	
void CommandPrintSerialPrompt(void)
{
extern unsigned char PS1[16];
static unsigned char i,buffer[16];
	
	UARTPrint("\n");
	i=sprintf (buffer, "%s> ", PS1);
	UARTPrint(buffer);
}

	
/*****************************************************
*                                                    *
*				CommandCheckForReturnKey           	 *
*                                                    *
******************************************************/	
unsigned char CommandCheckForReturnKey(void)
{
//Get data from serial port when enter key is pressed.
//Pass the command to the Command Interpreter

extern unsigned char receive_counter,password_entry;
extern unsigned char receive_buffer[32];
static unsigned char return_key_rec,old_receive_counter,i;

	return_key_rec = FALSE;
	old_receive_counter = receive_counter;
	for(i=0;i<32;i++)
		receive_buffer[i] = 0;
	receive_counter = 0;
	while(return_key_rec == FALSE)
	{
		while(receive_counter == old_receive_counter);
		
		if(receive_buffer[receive_counter-1] == 0x0d) //="/m"
		{
			_NOP();//used here because above and below lines same instruction
			return_key_rec = TRUE;//by compiler.
		}
		else if(password_entry == TRUE)
		{
			while((IFG1 & UTXIFG0) == 0);
				WriteUARTData(0x08);//backspace
			while((IFG1 & UTXIFG0) == 0);
				WriteUARTData('*');//backspace
		}	
		old_receive_counter = receive_counter;
	}
	receive_buffer[receive_counter-1] = 0;
	receive_counter = 0;
	UARTPrint("\n");
	return return_key_rec;
}

/*****************************************************
*                                                    *
*				CommandCheckForValidCommand        	 *
*                                                    *
******************************************************/	

unsigned char CommandCheckForValidCommand(void)
{		
	//Check that the entered text is a valid command.
	//Then forward to the Command Handler
		
	/*
	ps = PS1 in Unix
	cl = clear (screen)
	lo = logout
	v = version, returns version of pqrst commander
	sp = set port, set output pins to value
	? = help, lists all of the supported commands
		
	*/

extern unsigned char receive_buffer[32];
unsigned char command=0;
	
	//Check for backspace = 0x08
	CommandHandleBackspaces();
	
	if(receive_buffer[0]=='p' && receive_buffer[1]=='s')
		command = CommandHandleCommandPromptString();	
	else if(receive_buffer[0]=='c' && receive_buffer[1]=='l' && receive_buffer[2]==0)
		command = CommandHandleCommandClearScreen();
	else if(receive_buffer[0]=='l' && receive_buffer[1]=='o' && receive_buffer[2]==0)
		command = CommandHandleCommandLogOut();
	else if(receive_buffer[0]=='v' && receive_buffer[1]==0)
		command = CommandHandleCommandVersion();
	else if(receive_buffer[0]=='s' && receive_buffer[1]=='p')
		command = CommandHandleCommandSetPort();
	else if(receive_buffer[0]=='?' && receive_buffer[1]==0)
		command = CommandHandleCommandHelp();
	else if(receive_buffer[0]=='p' && receive_buffer[1]=='r')
		command = CommandHandleCommandPortRead();
	else if(receive_buffer[0]=='p' && receive_buffer[1]=='d')
		command = CommandHandleCommandPortDirection();
	else if(receive_buffer[0]=='p' && receive_buffer[1]=='m')
		command = CommandHandleCommandPortMUX();
	else if(receive_buffer[0]=='s' && receive_buffer[1]=='u' && receive_buffer[2]=='1' && receive_buffer[3]==0)
		command = CommandHandleCommandSetUser();
	else if(receive_buffer[0]=='s' && receive_buffer[1]=='u' && receive_buffer[2]=='2' && receive_buffer[3]==0)
		command = CommandHandleCommandSetUser();
	else if(receive_buffer[0]=='r' && receive_buffer[1]=='b' && receive_buffer[2]==0)
		CommandHandleCommandReboot();
	else if(receive_buffer[0]=='m' && receive_buffer[1]=='r' && receive_buffer[2]=='=')
		command = CommandHandleCommandMemoryRead();
	else if(receive_buffer[0]=='l' && receive_buffer[1]=='c')
		command = CommandHandleCommandLoadConfig();
	else if(receive_buffer[0]=='p' && receive_buffer[1]=='l')
		CommandHandleCommandPrintLine();
	else
		command=INVALID;
	return command;
}

/*****************************************************
*                                                    *
*		CommandHandleCommandPromptString(ps)   	 	 *
*                                                    *
******************************************************/									
unsigned char CommandHandleCommandPromptString(void)
{
static unsigned char i;
extern unsigned char receive_buffer[32],PS1[16];

	i=0;
	while(i < 16 && receive_buffer[i] != 0)
	{
		PS1[i] = receive_buffer[i+3];
		i++;
	}
	while(i < 16)
	{
		PS1[i] = 0;
		i++;
	}
	return TRUE;
}

/*****************************************************
*                                                    *
*		CommandHandleCommandClearScreen(cl)    	 	 *
*                                                    *
******************************************************/			
unsigned char CommandHandleCommandClearScreen(void)
{
#define cls_lines		32
static unsigned char i		;
	for(i=0;i<cls_lines;i++)
		UARTPrint("\n");
	return TRUE;
}
		
/*****************************************************
*                                                    *
*		CommandHandleCommandLogOut(lo)       	 	 *
*                                                    *
******************************************************/	
unsigned char CommandHandleCommandLogOut(void)
{
extern unsigned char login;

	login = FALSE;
	/*
	i = 0;
	while(prompt[i] != 0)
	{
		PS1[i]=prompt[i];
		i++;
	}
	*/
	return TRUE;
}

/*****************************************************
*                                                    *
*		CommandHandleCommandVersion(v)       	 	 *
*                                                    *
******************************************************/	
unsigned char CommandHandleCommandVersion(void)
{
	UARTPrint("01.00\n");
	return TRUE;
}

/*****************************************************
*                                                    *
*		CommandHandleCommandSetPort(sp)    	 		 *
*                                                    *
******************************************************/	
unsigned char CommandHandleCommandSetPort(void)
{		
extern unsigned char receive_buffer[32],PS1[16],login;
//extern unsigned int global_int;
static unsigned char value,portValue[2];
static unsigned char bit,period=FALSE;
static unsigned char lowNibble, highNibble;
static unsigned int portValueBinary;
static unsigned char hundreds, tens, ones;

		//sp1=255
		//sp1=xff
		//0123456
		//sp1.1=1
		//0123456
		//need to convert all text into numeric values
		period=FALSE;
		hundreds = 0;
		tens = 0;
		ones = 0;

		value = receive_buffer[PORT_NUMBER_POSITION];
		//portNumber = CommandConvAsciiToNumeric(value);
		if(receive_buffer[PERIOD_POSITION] == '.')
			period = TRUE;
		if(period)
		{
			portValue[0] = (unsigned char)receive_buffer[PERIOD_POSITION+1];
			portValue[1] = (unsigned char)0;
			bit = CommandConvAsciiToNumeric((unsigned char)portValue);
			switch(value)		//(port_number)
			{
				case '1':
				if(receive_buffer[BIT_POSITION]=='1')
					P1OUT |= 2^bit;
				else
					P1OUT &= ~2^bit;
				break;
				
				case '2':
				if(receive_buffer[BIT_POSITION]=='1')
					P2OUT |= 2^bit;
				else
					P2OUT &= ~2^bit;
				break;
				
				case '3':
				if(receive_buffer[BIT_POSITION]=='1')
					P3OUT |= 2^bit;
				else
					P3OUT &= ~2^bit;
				break;
				
				case '4':
				if(receive_buffer[BIT_POSITION]=='1')
					P4OUT |= 2^bit;
				else
					P4OUT &= 2^bit;
				break;
		
				case '5':
				if(receive_buffer[BIT_POSITION]=='1')
					P5OUT |= 2^bit;
				else
					P5OUT &= ~2^bit;
				break;
				
				case '6':
				if(receive_buffer[BIT_POSITION]=='1')
					P6OUT |= 2^bit;
				else
					P6OUT &= ~2^bit;
				break;
			}
		}
		else 
		{
			if(receive_buffer[4] == 'x')
			{
				portValue[0] = receive_buffer[HIGH_NIBBLE];
				portValue[1] = receive_buffer[LOW_NIBBLE];
				highNibble = CommandConvAsciiToNumeric(portValue[0]);
				lowNibble = CommandConvAsciiToNumeric(portValue[1]);
				portValueBinary = (highNibble << 4) | lowNibble;
				//portValueBinary = CommandConvAsciiToNumeric((unsigned char)*portValue);
			}
			else
			{
				//sp1=255
				if(receive_buffer[FIRST_DECIMAL_POSITION + 1] == 0)
					ones = CommandConvAsciiToNumeric(receive_buffer[FIRST_DECIMAL_POSITION]);
				else if(receive_buffer[SECOND_DECIMAL_POSITION + 1] == 0)
				{
					tens = CommandConvAsciiToNumeric(receive_buffer[FIRST_DECIMAL_POSITION]);
					ones = CommandConvAsciiToNumeric(receive_buffer[SECOND_DECIMAL_POSITION]);
				}			
				else if(receive_buffer[THIRD_DECIMAL_POSITION + 1] == 0)
				{
					hundreds = CommandConvAsciiToNumeric(receive_buffer[FIRST_DECIMAL_POSITION]);
					tens = CommandConvAsciiToNumeric(receive_buffer[SECOND_DECIMAL_POSITION]);
					ones = CommandConvAsciiToNumeric(receive_buffer[THIRD_DECIMAL_POSITION]);
				}				
				portValueBinary = (hundreds * 100) + (tens * 10) + ones; 
			}
			
			switch(value)
			{
				case '1':
				P1OUT = portValueBinary;
				break;
				
				case '2':
				P2OUT = portValueBinary;
				break;
				
				case '3':
				P3OUT = portValueBinary;
				break;
				
				case '4':
				P4OUT = portValueBinary;
				break;	
				
				case '5':
				P5OUT = portValueBinary;
				break;
				
				case '6':
				P6OUT = portValueBinary;
				break;
			}
		}
		return TRUE;
}

/*****************************************************
*                                                    *
*		CommandHandleCommandSetHelp(?)       	 	 *
*                                                    *
******************************************************/	
unsigned char CommandHandleCommandHelp(void)
{		
	UARTPrint("pqrst commander v01.00\n");
	UARTPrint("-cl clears the screen\n");
	UARTPrint("-ps ps=prompt changes command prompt text\n");
	UARTPrint("-lo logout\n");
	UARTPrint("-v  prints version of commander\n");
	UARTPrint("-sp#.#=# sets port and bits, sp1.1=1,sp1.1=0\n");
	UARTPrint("   set whole port, sp1=xff, sp1=255\n");
	UARTPrint("-pr# reads port value pr1, pr6\n");
	UARTPrint("     prp displays all port values until <ENTER>\n");
	UARTPrint("-pd#.#=# sets port direction, pd1.1=1,pd1.1=0\n");
	UARTPrint("   set whole port direction, pd1=xff, pd1=255\n");
	UARTPrint("   output=1, input=0\n");
	UARTPrint("-pm#.#=# set muxed port pins via P#SEL registers\n");
	UARTPrint("   works as pd command above\n");
	UARTPrint("-su# sets new user. su1 replaces root, su2 for limited permissions\n");
	UARTPrint("-rb reboot pqrst commander.\n");
//	UARTPrint("-mw memory write, mw address,data; mw 0x1080,0xaa.\n");
//	UARTPrint("    address must be 4 digits, data 2 digits.\n");
//	UARTPrint("    range 0x1080 to 0x10ff.\n");
//	UARTPrint("    free range of ROM 0x8000 to 0xf000\n");
//	UARTPrint("	   be careful using the mw command.\n");
	UARTPrint("-mr memory read, can read any location of ROM.\n");
	UARTPrint("    mr=x1000 will return value in hex at address x1000\n");
	UARTPrint("    address must be 4 digits long.\n");
	UARTPrint("-lc load config. load config file using config.txt template.\n");
	//Add command for printing out config.txt file template
	//Also change port settings to all inputs.
	UARTPrint("-pl print line. prints textup to 29 chars. ex. pl press <enter>\n"); 	
	
	UARTPrint("-\n");
	//UARTPrint("\n");
	return TRUE;
}		

/*****************************************************
*                                                    *
*		CommandHandleCommandPortRead(pr)       	 	 *
*                                                    *
******************************************************/				
unsigned char CommandHandleCommandPortRead(void)
{
extern unsigned char receive_buffer[32],receive_counter;
static unsigned char value,portValue[2],transmitBuffer[32],i;
static unsigned int numeric;
static unsigned char text[68];
#define P_POSITION 2
	//rp1
	//rp1.1
	//rp1p
	if(receive_buffer[P_POSITION] == 'p')
	{
		for(i=0;i<68;i++)
			text[i] = 0;
		while(receive_counter == 0 )
		{
			numeric = sprintf(text,"P1IN=x%x   P2IN=x%x   P3IN=x%x   P4IN=x%x   P5IN=x%x   P6IN=x%x     \r",\
				P1IN,P2IN,P3IN,P4IN,P5IN,P6IN);
			UARTPrint((unsigned char *)text);
		}
		receive_counter = 0;
		UARTPrint("\n");
	}
	else
	{
		for(i=0;i<32;i++)
			transmitBuffer[i] = 0;
		value = receive_buffer[PORT_NUMBER_POSITION];	
		switch(value)
		{
		
			case '1':	
			value = P1IN;
			numeric=sprintf(portValue,"%x",value);			//convert binary data to hex
			break;
		
			case '2':
			value = P2IN;
			numeric=sprintf(portValue,"%x",value);			//convert binary data to hex
			break;
			
			case '3':
			value = P3IN;
			numeric=sprintf(portValue,"%x",value);			//convert binary data to hex
			break;
		
			case '4':
			value = P4IN;
			numeric=sprintf(portValue,"%x",value);			//convert binary data to hex
			break;
		
			case '5':
			value = P5IN;
			numeric=sprintf(portValue,"%x",value);			//convert binary data to hex
			break;
		
			case '6':
			value = P6IN;
			numeric=sprintf(portValue,"%x",value);			//convert binary data to hex
			break;
		}
	}
	numeric = sprintf(transmitBuffer,"P%cIN=x%s\n",receive_buffer[PORT_NUMBER_POSITION], portValue); 
	transmitBuffer[8] = 0;
	UARTPrint((unsigned char *)transmitBuffer);
	return TRUE;
}
/*****************************************************
*                                                    *
*		CommandHandleCommandPortDirection(pd)        *
*                                                    *
******************************************************/	
unsigned char CommandHandleCommandPortDirection	(void)
{
extern unsigned char receive_buffer[32],PS1[16],login;
//extern unsigned int global_int;
static unsigned char value,portValue[2];
static unsigned char bit,period=FALSE;
static unsigned char lowNibble, highNibble;
static unsigned char hundreds, tens, ones;	
static unsigned int portValueBinary;

	//pd1=xff
	//pd1=xff
	//0123456
	//pd1.1=1
	//0123456
	//need to convert all text into numeric values
	hundreds=0;
	tens=0;
	ones=0;
	period=FALSE;
	value = receive_buffer[PORT_NUMBER_POSITION];
	//portNumber = CommandConvAsciiToNumeric(value);
	if(receive_buffer[PERIOD_POSITION] == '.')
		period = TRUE;
	if(period)
	{
		portValue[0] = (unsigned char)receive_buffer[PERIOD_POSITION+1];
		portValue[1] = (unsigned char)0;
		bit = CommandConvAsciiToNumeric((unsigned char)portValue);
		switch(value)		//(port_number)
		{
			case '1':
			if(receive_buffer[BIT_POSITION]=='1')
				P1DIR |= 2^bit;
			else
				P1DIR &= ~2^bit;
			break;
			
			case '2':
			if(receive_buffer[BIT_POSITION]=='1')
				P2DIR |= 2^bit;
			else
				P2DIR &= ~2^bit;
			break;
			
			case '3':
			if(receive_buffer[BIT_POSITION]=='1')
				P3DIR |= 2^bit;
			else
				P3DIR &= ~2^bit;
			break;
			
			case '4':
			if(receive_buffer[BIT_POSITION]=='1')
				P4DIR |= 2^bit;
			else
				P4DIR &= 2^bit;
			break;
	
			case '5':
			if(receive_buffer[BIT_POSITION]=='1')
				P5DIR |= 2^bit;
			else
				P5DIR &= ~2^bit;
			break;
			
			case '6':
			if(receive_buffer[BIT_POSITION]=='1')
				P6DIR |= 2^bit;
			else
				P6DIR &= ~2^bit;
			break;
		}
	}
	else
	{
		if(receive_buffer[4] == 'x')
		{
			portValue[0] = receive_buffer[HIGH_NIBBLE];
			portValue[1] = receive_buffer[LOW_NIBBLE];
			highNibble = CommandConvAsciiToNumeric(portValue[0]);
			lowNibble = CommandConvAsciiToNumeric(portValue[1]);
			portValueBinary = (highNibble << 4) | lowNibble;
			//portValueBinary = CommandConvAsciiToNumeric((unsigned char)*portValue);
		}
		else
		{
			//sp1=255
			if(receive_buffer[FIRST_DECIMAL_POSITION + 1] == 0)
				ones = CommandConvAsciiToNumeric(receive_buffer[FIRST_DECIMAL_POSITION]);
			else if(receive_buffer[SECOND_DECIMAL_POSITION + 1] == 0)
			{
				tens = CommandConvAsciiToNumeric(receive_buffer[FIRST_DECIMAL_POSITION]);
				ones = CommandConvAsciiToNumeric(receive_buffer[SECOND_DECIMAL_POSITION]);
			}			
			else if(receive_buffer[THIRD_DECIMAL_POSITION + 1] == 0)
			{
				hundreds = CommandConvAsciiToNumeric(receive_buffer[FIRST_DECIMAL_POSITION]);
				tens = CommandConvAsciiToNumeric(receive_buffer[SECOND_DECIMAL_POSITION]);
				ones = CommandConvAsciiToNumeric(receive_buffer[THIRD_DECIMAL_POSITION]);
			}				
			portValueBinary = (hundreds * 100) + (tens * 10) + ones; 
		}
		
		switch(value)
		{
			case '1':
			P1DIR = portValueBinary;
			break;
			
			case '2':
			P2DIR = portValueBinary;
			break;
			
			case '3':
			P3DIR = portValueBinary;
			break;
				
			case '4':
			P4DIR = portValueBinary;
			break;	
				
			case '5':
			P5DIR = portValueBinary;
			break;
				
			case '6':
			P6DIR = portValueBinary;
			break;
		}
	}
	return TRUE;
}

/*****************************************************
*                                                    *
*		CommandHandleCommandPortMUX(pm)        		 *
*                                                    *
******************************************************/	
unsigned char CommandHandleCommandPortMUX(void)
{
extern unsigned char receive_buffer[32],PS1[16],login;
//extern unsigned int global_int;
static unsigned char value,portValue[2];
static unsigned char bit,period=FALSE;
static unsigned char lowNibble, highNibble;
static unsigned int portValueBinary;
static unsigned char hundreds, tens, ones;	

	//pm1=xff
	//pm1=xff
	//0123456
	//pm1.1=1
	//0123456
	//need to convert all text into numeric values
	hundreds=0;
	tens=0;
	ones=0;
	period=FALSE;
	value = receive_buffer[PORT_NUMBER_POSITION];
	//portNumber = CommandConvAsciiToNumeric(value);
	if(receive_buffer[PERIOD_POSITION] == '.')
		period = TRUE;
	if(period)
	{
		portValue[0] = (unsigned char)receive_buffer[PERIOD_POSITION+1];
		portValue[1] = (unsigned char)0;
		bit = CommandConvAsciiToNumeric((unsigned char)portValue);
		switch(value)		//(port_number)
		{
			case '1':
			if(receive_buffer[BIT_POSITION]=='1')
				P1SEL |= 2^bit;
			else
				P1SEL &= ~2^bit;
			break;
		
			case '2':
			if(receive_buffer[BIT_POSITION]=='1')
				P2SEL |= 2^bit;
			else
				P2SEL &= ~2^bit;
			break;
		
			case '3':
			if(receive_buffer[BIT_POSITION]=='1')
				P3SEL |= 2^bit;
			else
				P3SEL &= ~2^bit;
			break;
		
			case '4':
			if(receive_buffer[BIT_POSITION]=='1')
				P4SEL |= 2^bit;
			else
				P4SEL &= 2^bit;
			break;

			case '5':
			if(receive_buffer[BIT_POSITION]=='1')
				P5SEL |= 2^bit;
			else
				P5SEL &= ~2^bit;
			break;
		
			case '6':
			if(receive_buffer[BIT_POSITION]=='1')
				P6SEL |= 2^bit;
			else
				P6SEL &= ~2^bit;
			break;
		}
	}
	else //bracket ok here
	{
		if(receive_buffer[4] == 'x')
		{
			portValue[0] = receive_buffer[HIGH_NIBBLE];
			portValue[1] = receive_buffer[LOW_NIBBLE];
			highNibble = CommandConvAsciiToNumeric(portValue[0]);
			lowNibble = CommandConvAsciiToNumeric(portValue[1]);
			portValueBinary = (highNibble << 4) | lowNibble;
			//portValueBinary = CommandConvAsciiToNumeric((unsigned char)*portValue);
		}
		else
		{
			//sp1=255
			if(receive_buffer[FIRST_DECIMAL_POSITION + 1] == 0)
				ones = CommandConvAsciiToNumeric(receive_buffer[FIRST_DECIMAL_POSITION]);
			else if(receive_buffer[SECOND_DECIMAL_POSITION + 1] == 0)
			{
				tens = CommandConvAsciiToNumeric(receive_buffer[FIRST_DECIMAL_POSITION]);
				ones = CommandConvAsciiToNumeric(receive_buffer[SECOND_DECIMAL_POSITION]);
			}			
			else if(receive_buffer[THIRD_DECIMAL_POSITION + 1] == 0)
			{
				hundreds = CommandConvAsciiToNumeric(receive_buffer[FIRST_DECIMAL_POSITION]);
				tens = CommandConvAsciiToNumeric(receive_buffer[SECOND_DECIMAL_POSITION]);
				ones = CommandConvAsciiToNumeric(receive_buffer[THIRD_DECIMAL_POSITION]);
			}				
			portValueBinary = (hundreds * 100) + (tens * 10) + ones; 
		}
	}	
	switch(value)
	{
		case '1':
		P1SEL = portValueBinary;
		break;
		
		case '2':
		P2SEL = portValueBinary;
		break;
		
		case '3':
		P3SEL = portValueBinary;
		break;
		
		case '4':
		P4SEL = portValueBinary;
		break;	
		
		case '5':
		P5SEL = portValueBinary;
		break;
		
		case '6':
		P6SEL = portValueBinary;
		break;
	}
	return TRUE;
	
}

/*****************************************************
*                                                    *
*		CommandHandleCommandPortSetUser(su)        	 *
*                                                    *
******************************************************/	
unsigned char CommandHandleCommandSetUser(void)
{
extern unsigned char receive_buffer[32],PS1[16],login,permission;
static unsigned char i,result=FALSE,userNumber;
static unsigned char transmitBuffer[32],memBuffer[128],command[3];
static unsigned int numeric;
static unsigned char username1[16],username2[16],password1[16],password2[16];
	//su1, su2
	//current login:
	//current password:
	//check match
	if(permission)
	{
		strcpy(command,receive_buffer);
		numeric = FALSE;
		numeric = CommandLoginHandler();
		userNumber = (unsigned char)command[USER_NUMBER]; //needed to get compiler to handle ifs.
		if(numeric)
		{
			//determine user
			
			//username1:
			//confirm username1:
			//password:
			//confirm password:
			//username1 login set
			numeric = sprintf(transmitBuffer,"set username%c: ",command[USER_NUMBER]);
			UARTPrint(transmitBuffer);
	
			while(!CommandCheckForReturnKey());
			CommandHandleBackspaces();
			i = 0;
			while(receive_buffer[i] != 0)
			{
				username1[i] = receive_buffer[i];
				i++;
			}
			username1[i] = 0;
			numeric = sprintf(transmitBuffer,"confirm username%c: ",command[USER_NUMBER]);
			UARTPrint(transmitBuffer);

			while(!CommandCheckForReturnKey());
			CommandHandleBackspaces();
			i = 0;
			while(receive_buffer[i] != 0)
			{
				username2[i] = receive_buffer[i];
				i++;
			}
			username2[i] = 0;
			if(!(strcmp(username1,username2)))
			{
				password_entry = TRUE;
				numeric = sprintf(transmitBuffer,"set password%c: ",command[USER_NUMBER]);
				UARTPrint(transmitBuffer);
	
				while(!CommandCheckForReturnKey());
				CommandHandleBackspaces();
				i = 0;
				while(receive_buffer[i] != 0)
				{
					password1[i] = receive_buffer[i];
					i++;
				}
				password1[i] = 0;
				numeric = sprintf(transmitBuffer,"confirm password%c: ",command[USER_NUMBER]);
				UARTPrint(transmitBuffer);
	
				while(!CommandCheckForReturnKey());
				CommandHandleBackspaces();
				password_entry = FALSE;
				i = 0;
				while(receive_buffer[i] != 0)
				{
					password2[i] = receive_buffer[i];
					i++;
				}
				password2[i] = 0;
				if(!(strcmp(password1,password2)))
				{
					//Store new password
					//Store flash memory
					for(i=0;i<128;i++)
						memBuffer[i] = FlashRead((unsigned char *)(FLASH_SETTINGS_ST_ADDR + i));

					i=0;
					while(username1[i] && i < 16)
					{	
						if(userNumber == '1')
							memBuffer[USERNAME_OFFSET + i] = username1[i];
						if(userNumber == '2')
							memBuffer[USERNAME2_OFFSET + i] = username1[i];
						i++;
					} 
					if(i != 16 && userNumber == '1')
						memBuffer[USERNAME_OFFSET + i] = 0;
					if(i != 16 && userNumber == '2')
						memBuffer[USERNAME2_OFFSET + i] = 0;
					i=0;
					while(password1[i] && i < 16)
					{
						if(userNumber == '1')
							memBuffer[PASSWORD_OFFSET + i] = password1[i];
						if (userNumber == '2')
							memBuffer[PASSWORD2_OFFSET + i] = password1[i];
						i++;
					}
					if(i != 16 && userNumber == '1')
						memBuffer[PASSWORD_OFFSET + i] = 0;
					if(i != 16 && userNumber == '2')
						memBuffer[PASSWORD2_OFFSET + i] = 0;
					FlashInit();
					FlashErase((unsigned char *)FLASH_SETTINGS_ST_ADDR);
					for(i=0;i<128;i++)
					{
						FlashInit();
						FlashWrite((unsigned char *)(FLASH_SETTINGS_ST_ADDR + i), memBuffer[i]);
					}
					if(userNumber == '1')
						UARTPrint("new user login set. root login no longer valid.\n");
					if (userNumber == '2')
						UARTPrint("new user login set with limited permissions.\n");
					result = TRUE;
				}
				else
					UARTPrint("passwords did not match!\n");
			}
			else
				UARTPrint("usernames did not match!\n");				
		}
		else
			UARTPrint("access Denied\n");
	}
	else
	{
		UARTPrint("insufficeint permissions!\n");
		result = FALSE;
	}
	return result;					
}	

/*****************************************************
*                                                    *
*			CommandHandleCommandMemoryRead(mr) 	 	 *
*                                                    *
******************************************************/	
unsigned char CommandHandleCommandMemoryRead(void)
{
static unsigned char memData,printBuffer[32],i,memAddressBin[4];
static unsigned char hbhn,hbln,lbhn,lbln;
static unsigned int memAddress;
extern unsigned char receive_buffer[32];
#define HEX_SYM 3				//mr=x1000
#define HBHN	HEX_SYM + 1
#define HBLN	HEX_SYM + 2
#define LBHN	HEX_SYM + 3
#define LBLN	HEX_SYM + 4
	//Do not allow for reading of username and password data
	//Allow for reading of all other locations
	if(receive_buffer[HEX_SYM] == 'x')// && receive_buffer[HEX_SYM + 1] == 'x')
	{	
		
		memAddressBin[0] = receive_buffer[HBHN];
		memAddressBin[1] = receive_buffer[HBLN];
		memAddressBin[2] = receive_buffer[LBHN];
		memAddressBin[3] = receive_buffer[LBLN];
		hbhn = CommandConvAsciiToNumeric(memAddressBin[0]);
		hbln = CommandConvAsciiToNumeric(memAddressBin[1]);
		lbhn = CommandConvAsciiToNumeric(memAddressBin[2]);
		lbln = CommandConvAsciiToNumeric(memAddressBin[3]);
		memAddress = 0;
		memAddress = (hbhn << 4) | hbln;
		memAddress = (memAddress << 8) & 0xFF00;
		memAddress = memAddress | ((lbhn << 4) | (lbln));
	
		if(memAddress >= USERNAME_START_ADDR && memAddress <= (PASSWORD2_START_ADDR + 15))
		{
			UARTPrint("read location prohibited\n");
			memData = 0;	//should return something like -1 0 through 0xFF all valid data
		}
		else
		{
			memData = FlashRead((unsigned char *)memAddress);
			i = sprintf(printBuffer,"*0x%x=0x%x\n",memAddress,memData);
			UARTPrint((unsigned char *)printBuffer);
		}
	}
	return memData;
}

/*****************************************************
*                                                    *
*		CommandHandleCommandMemoryWrite(mw)	 	 	 *
*                                                    *
******************************************************/	

/*

512 byte blocks
Need 512 byte buffer
Erase flash
Write Flash Signal PC that Write is complete
Ready for next block
Until EOF
*/


/*****************************************************
*                                                    *
*			CommandHandleCommandReset(rs)   	 	 *
*                                                    *
******************************************************/	
void CommandHandleCommandReset(void)
{
	/*
	This command is should never be used
	except in the case where passwords are
	forgotten and need to be cleared.
	This will also delete any flash location
	allocated for storage.  This command is
	not listed in the help screen.
	*/
	
	//erase info memory
	FlashInit();
	FlashErase((unsigned char *)FLASH_SETTINGS_ST_ADDR);
	FlashInit();
	FlashErase((unsigned char *)0x1080);
	//erase Flash locations allocated for storage
}


/*****************************************************
*                                                    *
*		CommandHandleCommandLoadConfig(lc)	 	 	 *
*                                                    *
******************************************************/	
unsigned char CommandHandleCommandLoadConfig(void)
{
extern unsigned char receive_buffer[32],receive_counter,configFile[256];
extern unsigned char receiveMode;
static unsigned char memBuffer[128],return_key_rec;
static unsigned char old_receive_counter,i,j,startPosition;
#define PRINTCONFIG	2
	
	if(receive_buffer[PRINTCONFIG] == 'p')
	{
		UARTPrint("copy below text between dashed lines into a separate file.\n");
		UARTPrint("modify as needed and use lc command do load file.\n");
		UARTPrint("remember PORT3 is used for UART communications\n.");
		UARTPrint("Use only lower case letter for hex values!\n");
		UARTPrint("----------\n");
		UARTPrint("#config.txt\n");
		UARTPrint("#msp430f149\n");
		UARTPrint("sp1=x00\n");							
		UARTPrint("pd1=x00\n");
		UARTPrint("pm1=x00\n");
		UARTPrint("sp2=x00\n");
		UARTPrint("pd2=x00\n");
		UARTPrint("pm2=x00\n");
		UARTPrint("sp3=xC2\n");
		UARTPrint("pd3=x57\n");
		UARTPrint("pm3=x00\n");
		UARTPrint("sp4=x00\n");
		UARTPrint("pd4=x00\n");					
		UARTPrint("pm4=x00\n");
		UARTPrint("sp5=x00\n");
		UARTPrint("pd5=x00\n");
		UARTPrint("pm5=x00\n");
		UARTPrint("sp6=x00\n");
		UARTPrint("pd6=x00\n");
		UARTPrint("pm6=x00\n");
		UARTPrint("#rlf\n");
		UARTPrint("^D\n");
		UARTPrint("----------\n");	
	}
	else
	{
		//for(i=0;i<256;i++)
		//	configFile[i]=0;
		UARTPrint("load config file\n");
		UARTPrint("press <Enter> to continue or 'c' then <Enter> to cancel.\n");
		CommandCheckForReturnKey();
		//Load config file
		receiveMode = CONFIG;
		if(receive_buffer[0] != 'c')
		{
			UARTPrint("send file as text file only!\n");
			//EOT = 0x04=^D
			return_key_rec = FALSE;
			old_receive_counter = receive_counter;
			receive_counter = 0;
			while(return_key_rec == FALSE)
			{
				while(receive_counter == old_receive_counter);
				old_receive_counter = receive_counter;
				//if(configFile[receive_counter] == ';')
				//	UARTPrint("\n");
				if(configFile[receive_counter-1] == 'D' && configFile[receive_counter-2] == '^') 
				{
					//_NOP();//used here because above and below lines same instruction
					return_key_rec = TRUE;//by compiler.
					configFile[receive_counter-2] = 0;
				}
			}
			receive_counter = 0;
			//Strip out comments, lines that start with #
			i=0;
			while(configFile[i] != 0)
			{
				if(configFile[i] == '#')
				{
					startPosition = i;
					j=0;
					while(configFile[i] != CARRIAGERETURN)
					{
						i++;
						j++;
					}
					i = i - j;
					//shift entire file by j bytes
					while(configFile[i] != 0)
					{
						configFile[i] = configFile[i + j + 1];
						i++;
					}
					i = startPosition;
				}
				else
					i++;
			}
			configFile[i] = EOT;
			for(i=0;i<128;i++)
				memBuffer[i] = FlashRead((unsigned char *)(FLASH_SETTINGS_ST_ADDR + i));
			//Erase Memory and load data into buffer
			for(i=0;i<48;i++)
				memBuffer[CONFIG_FILE_ST_OFFSET + i] = configFile[i]; 
			
			FlashInit();
			FlashErase((unsigned char *)FLASH_SETTINGS_ST_ADDR);
			//Load file received into first part of information memory
			for(i=0;i<128;i++)
			{
				FlashInit();
				FlashWrite((unsigned char *)FLASH_SETTINGS_ST_ADDR + i, memBuffer[i]);
			}	
			//Load the other part of config into second block of information memory
			FlashInit();
			FlashErase((unsigned char *)FLASH_SETTINGS_B2_ADDR);
			i=0;
			while(configFile[48 + i] != EOT && i < 128)
			{
				FlashInit();
				FlashWrite((unsigned char *)FLASH_SETTINGS_B2_ADDR + i, configFile[48 + i]);	
				i++;
			}
			FlashWrite((unsigned char *)FLASH_SETTINGS_B2_ADDR + i, EOT);	
		}	
	}
	receiveMode = COMMAND;
	return TRUE;
}

/*****************************************************
*                                                    *
*			CommandHandleCommandPrintLine(pl)   	 *
*                                                    *
******************************************************/	
void CommandHandleCommandPrintLine(void)
{
extern unsigned char receive_buffer[32];
static unsigned char i,text[32];
#define COMMAND_OFFSET	3
	i = 0;
	while(receive_buffer[i] != 0 && i <32)
	{
		text[i] = receive_buffer[i + COMMAND_OFFSET];
		i++;
	}
	text[i] = 0;
	UARTPrint((unsigned char *)text);
	UARTPrint("\n");
}

/*****************************************************
*                                                    *
*				CommandHandleCommandReboot(rb)   	 *
*                                                    *
******************************************************/	
void CommandHandleCommandReboot(void)
{
/$ 
	.extern	cstart	
	jmp cstart
$/
}

/*****************************************************
*                                                    *
*				CommandHandleBackspaces   	 		 *
*                                                    *
******************************************************/	
void CommandHandleBackspaces(void)
{
static unsigned char i;

	i=0;
	while(i < 32 && receive_buffer[i] != 0)
	{
		if(receive_buffer[i] == 0x08)	//backspace
		{
			receive_buffer[i]=	receive_buffer[i+1];
			i=i+2;
		}
		else
			i++;
	}
}

/*****************************************************
*                                                    *
*				CommandConvAsciiToNumeric        	 *
*                                                    *
******************************************************/	
unsigned char CommandConvAsciiToNumeric (unsigned char charToConvert)
{
//could not get code after function to work, so used this method instead.
 static unsigned char number;
	number	= 0;
	switch(charToConvert)
	{
		case '0':
		number=0;
		break;
		
		case '1':
		number=1;
		break;
		
		case '2':
		number=2;
		break;
		
		case '3':
		number=3;
		break;
		
		case '4':
		number=4;
		break;
		
		case '5':
		number=5;
		break;
		
		case '6':
		number=6;
		break;
		
		case '7':
		number=7;
		break;
		
		case '8':
		number=8;
		break;
		
		case '9':
		number=9;
		break;
		
		case 'a':
		number=10;
		break;
		
		case 'b':
		number=11;
		break;
		
		case 'c':
		number=12;
		break;
		
		case 'd':
		number=13;
		break;
		
		case 'e':
		number=14;
		break;
		
		case 'f':
		number=15;
		break;
	}
	return number;
}

/*static unsigned long valueLong;
 static unsigned int valueInt;
 //BELOW IS FOR DEBUG ONLY
 extern unsigned int global_int;
 extern unsigned long global_long;
 extern unsigned char global_char1[32];
 static unsigned char i;
 static unsigned char efef[]="0xff ";
 for(i=0;i<32;i++)
 	global_char1[i]=0;
 *global_char1 = (unsigned char)strToConvert;
 //ABOVE IS FOR DEBUG ONLY
 valueLong = strtol(*efef, NULL, 16);
 global_long = valueLong;
 _NOP();
 valueInt = (unsigned int)valueLong;
 global_int = valueInt;
 _NOP();
 return valueInt;
}
*/
/*
#include <stdio.h>
#include <stdlib.h>

 

void main() {
 char *strToConvert;
 printf("Enter string\n");
 scanf("%s", strToConvert);
 long value = strtol(strToConvert, NULL, 16);
 printf("The converted value is %d\n", value);
}
*/
/*
char ConvAsciiCharToNumeric(char char_to_conv)
*/
